/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.lspeed;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;

public class OC3StatusPollAction
implements StatusMapper,
TableStatusNamer {
    private static String lspeedBundle = "ibm.nways.lspeed.LsGeneralResources";
    private static String enumBundle = "ibm.nways.lspeed.LsGeneralResources";
    private boolean loggingOn;

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(lspeedBundle, "OC3StatusTable");
        return i18NString;
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        System.out.println("LS: statu poll namer");
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(lspeedBundle, "OC3Status", objectArray);
        return i18NMsgFormat;
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
        if (statusModelInfo == null || !(statusModelInfo.get("OC3PortInfo.AdminStatus") instanceof Integer) || !(statusModelInfo.get("OC3PortInfo.OperStatus") instanceof Integer)) {
            statusAndExplain.statType = StatusType.UNKNOWN;
            statusAndExplain.explain = new I18NString(lspeedBundle, "MissingPollData");
        } else {
            Object[] objectArray = statusModelInfo.getIndexes();
            int n = (Integer)statusModelInfo.get("OC3PortInfo.AdminStatus");
            int n2 = (Integer)statusModelInfo.get("OC3PortInfo.OperStatus");
            statusAndExplain = this.evaluatePortStatus(n, n2, objectArray);
        }
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
        if (this.loggingOn) {
            System.out.println("LS:OC3StatusPollAction -new status = " + statusAndExplain.statType + " " + statusAndExplain.explain.getTranslation());
        }
    }

    private StatusAndExplain evaluatePortStatus(int n, int n2, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[2];
        if (n == 2) {
            statusAndExplain.statType = StatusType.ADMIN_DISABLED;
            objectArray2[0] = new I18NMsgFormat(lspeedBundle, "OC3PortAdminStatus", objectArray);
            objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.AdminStatus.disabled");
        } else {
            objectArray2[0] = new I18NMsgFormat(lspeedBundle, "OC3PortStatus", objectArray);
            switch (n2) {
                case 1: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.okay");
                    break;
                }
                case 19: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.okay-standby");
                    break;
                }
                case 24: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.backup-link");
                    break;
                }
                case 33: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.attach3174To8-3299");
                    break;
                }
                case 34: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.attach3174To32-3299");
                    break;
                }
                case 35: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.attach3174ToDirect");
                    break;
                }
                case 55: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.forwarding");
                    break;
                }
                case 56: {
                    statusAndExplain.statType = StatusType.NORMAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.blocked");
                    break;
                }
                case 3: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.jabber");
                    break;
                }
                case 5: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.remoteJabber");
                    break;
                }
                case 6: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.invalidData");
                    break;
                }
                case 7: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.lowLight");
                    break;
                }
                case 8: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.fifoOverrun");
                    break;
                }
                case 9: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.fifoUnderrun");
                    break;
                }
                case 12: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.mjlp");
                    break;
                }
                case 13: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.noCable");
                    break;
                }
                case 14: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.noSquelch");
                    break;
                }
                case 15: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.noPhantom");
                    break;
                }
                case 23: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.connecting");
                    break;
                }
                case 25: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.security-breach");
                    break;
                }
                case 29: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.macRemoved");
                    break;
                }
                case 30: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.notInserted");
                    break;
                }
                case 36: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.attach3174Unavailable");
                    break;
                }
                case 37: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.transientError");
                    break;
                }
                case 47: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.notConfigured");
                    break;
                }
                case 51: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.notPresent");
                    break;
                }
                case 53: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.link-unstable");
                    break;
                }
                case 57: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.listening");
                    break;
                }
                case 58: {
                    statusAndExplain.statType = StatusType.MARGINAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.learning");
                    break;
                }
                case 22: {
                    statusAndExplain.statType = StatusType.ADMIN_DISABLED;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.off");
                    break;
                }
                case 10: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.fatalError");
                    break;
                }
                case 2: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.linkFailure");
                    break;
                }
                case 4: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.remoteLinkFailure");
                    break;
                }
                case 11: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.partition");
                    break;
                }
                case 27: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.beacon");
                    break;
                }
                case 28: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.wireFault");
                    break;
                }
                case 41: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.beaconThresError");
                    break;
                }
                case 42: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.speedThresError");
                    break;
                }
                case 43: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.invalidImped");
                    break;
                }
                case 44: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.beaconWrapped");
                    break;
                }
                case 31: {
                    statusAndExplain.statType = StatusType.CRITICAL;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.speedMismatch");
                    break;
                }
                case 32: {
                    statusAndExplain.statType = StatusType.UNKNOWN;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.attach3174Unknown");
                    break;
                }
                default: {
                    statusAndExplain.statType = StatusType.UNKNOWN;
                    objectArray2[1] = new I18NString(enumBundle, "ibm.nways.lspeed.model.LsOC3StatusPortModel.OC3PortInfo.OperStatus.unknownStatus");
                }
            }
            statusAndExplain.explain = new I18NGiblets(lspeedBundle, "OC3PortStatusorder", objectArray2);
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NString explain;

        StatusAndExplain() {
            OC3StatusPollAction.this = OC3StatusPollAction.this;
        }
    }
}

